/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.expression;

import javax.annotation.Nonnull;
import org.orecruncher.lib.expression.IVariant;
import org.orecruncher.lib.expression.Variant;

public class BooleanValue
extends Variant {
    protected boolean value;

    public BooleanValue() {
        this.value = false;
    }

    public BooleanValue(boolean b) {
        this.value = b;
    }

    public BooleanValue(float f) {
        this.value = f != 0.0f;
    }

    public BooleanValue(@Nonnull String name) {
        super(name);
    }

    public BooleanValue(@Nonnull String name, boolean b) {
        super(name);
        this.value = b;
    }

    public BooleanValue(@Nonnull String name, float f) {
        super(name);
        this.value = f != 0.0f;
    }

    @Override
    public float asNumber() {
        return this.value ? 1.0f : 0.0f;
    }

    @Override
    @Nonnull
    public String asString() {
        return this.value ? "TRUE" : "FALSE";
    }

    @Override
    public boolean asBoolean() {
        return this.value;
    }

    @Override
    public int compareTo(@Nonnull IVariant variant) {
        return Boolean.compare(this.value, variant.asBoolean());
    }

    @Override
    @Nonnull
    public IVariant add(@Nonnull IVariant term) {
        return new BooleanValue(this.value || term.asBoolean());
    }
}

